(function(exports) {
let interface_types = {ethernet: 0, master: 1, rs: 2, can: 3, rs_short: 4, rs_without_tcp: 5, iec104: 6, dlms: 7}
let tab_name = {0: 'Ethernet', 2: 'RS-485', 3: 'CAN', 4: 'RS-485', 5: 'RS-485', 6: 'IEC61870-5-104', 7: 'DLMS'}

exports.show = async function (product_code_arr)
{
	//console.log(product_code_arr)
	const device_model_param = product_code_arr[2]
	//const device_model_param = 3
	/*let device_model_list = {
        0: [0, 2, 3],
        1: [0],
        2: [0, 2, 3],
        3: [0, 2, 3],
        4: [0, 2, 2],
        5: [0, 2, 2, 2, 3],
		55: [0, 2, 2, 2], //for special ETS without CAN
        6: [0, 2, 3, 3, 3],
		"old": [4, 3],
		"only_rs_short": [4]
	}*/
	let device_model_list = configuration.network_interface_list	

	if (product_code_arr[0] == common.MODEL_CODE().EM_12 && product_code_arr[1] == 4n) // EM-12T
	{
		device_model_list = configuration.network_interface_list_EM_12T
	}

	let tab_body = []
	let ul = $('<ul>')
	let table = $('<table>')

	let rs_is_one = true
	let can_is_one = true
	let rs_count = 0
	let can_count = 0
	for (let tab_number in device_model_list[device_model_param])
	{
		let tab_type = device_model_list[device_model_param][tab_number]
		if (tab_type == interface_types.rs 
			|| tab_type == interface_types.rs_short
			|| tab_type == interface_types.rs_without_tcp) { rs_count++ }
		else if (tab_type == interface_types.can) { can_count++ }
	}
	if (rs_count > 1) { rs_is_one = false }
	if (can_count > 1) { can_is_one = false }

	rs_number = 1
	can_number = 1
	for (tab_number in device_model_list[device_model_param])
	{
		let tab_type = device_model_list[device_model_param][tab_number]

		if (tab_type == interface_types.ethernet)
		{
			ul.append($(`<li><a href="#nw_tab${tab_number}">${tab_name[tab_type]}</a></li>`))
			tab_body[tab_number] = $(`<tbody id="nw_tab${tab_number}">`).addClass('nowrap_td').addClass('data_td')
			tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("ethernet_ip_address"), 0x2213, 2))
			tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("ethernet_net_mask"), 0x2213, 3))
			tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("ethernet_gateway"), 0x2213, 4))
			tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("ethernet_dns1"), 0x2213, 5))
			tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("ethernet_dns2"), 0x2213, 6))
			tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("ethernet_dhcp_enable"), 0x2213, 1))
			tab_body[tab_number].append($('<tr>').addClass('table_header').append($('<td colspan="2">').text(l100n.localize_string("Modbus TCP Slave"))))
			let params = {name: l100n.localize_string("slave_enable"), index: 0x2343, sub: 1}
			tab_body[tab_number].append(common.form_tag_tr_param(params))
			tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("slave_device_address"), 0x2343, 2))
			tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("slave_poll"), 0x2343, 5))
		}
		else if (tab_type == interface_types.rs 
			|| tab_type == interface_types.rs_short
			|| tab_type == interface_types.rs_without_tcp)
		{
			if (rs_is_one) { ul.append($(`<li><a href="#nw_tab${tab_number}">${tab_name[tab_type]}</a></li>`)) }
			else { ul.append($(`<li><a href="#nw_tab${tab_number}">${tab_name[tab_type]} ${rs_number}</a></li>`)) }
			tab_body[tab_number] = $(`<tbody id="nw_tab${tab_number}">`).addClass('nowrap_td')
			let params = {name: l100n.localize_string("rs_enable"), index: 0x2143 + (rs_number-1)*4, sub: 1}
			tab_body[tab_number].append(common.form_tag_tr_param(params).addClass('data_td'))
			tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("rs_data_rate"), 0x2143 + (rs_number-1)*4, 2).addClass('data_td'))
			tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("rs_parity"), 0x2143 + (rs_number-1)*4, 4).addClass('data_td'))
			tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("rs_stop_bits"), 0x2143 + (rs_number-1)*4, 5).addClass('data_td'))
			tab_body[tab_number].append($('<tr>').addClass('table_header').addClass('data_td').append($('<td colspan="2">').text(l100n.localize_string("Serial Status"))))
			tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("rs_overrun_EC"), 0x2141 + (rs_number-1)*4, 1).addClass('data_td'))
			tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("rs_frame_EC"), 0x2141 + (rs_number-1)*4, 2).addClass('data_td'))
			tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("rs_parity_EC"), 0x2141 + (rs_number-1)*4, 3).addClass('data_td'))
			tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("rs_rx_EC"), 0x2141 + (rs_number-1)*4, 4).addClass('data_td'))
			tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("rs_tx_EC"), 0x2141 + (rs_number-1)*4, 5).addClass('data_td'))
			tab_body[tab_number].append($('<tr>').addClass('table_header').addClass('data_td').append($('<td colspan="2">').text(l100n.localize_string("Modbus Settings"))))
			tab_body[tab_number].append($('<tr>').addClass('table_header_2').append($('<td colspan="2">').text(l100n.localize_string("rs_modbus_settings"))))
			if (tab_type == interface_types.rs
				|| tab_type == interface_types.rs_without_tcp)
			{
				tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("rs_slave_enable"), 0x2323 + (rs_number-1)*4, 1).addClass('data_td'))
			}
			
			tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("rs_device_address"), 0x2323 + (rs_number-1)*4, 2).addClass('data_td'))
			tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("rs_answer_delay"), 0x2323 + (rs_number-1)*4, 3).addClass('data_td'))
			tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("rs_poll_timeout"), 0x2323 + (rs_number-1)*4, 4).addClass('data_td'))
			if (tab_type == interface_types.rs 
				|| tab_type == interface_types.rs_without_tcp)
			{
				tab_body[tab_number].append($('<tr>').addClass('table_header_2').append($('<td colspan="2">').text(l100n.localize_string("rs_master_settings"))))
				tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("rs_master_enable"), 0x2333 + (rs_number-1)*4, 1).addClass('data_td'))
				//tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("rs_startup_delay"), 0x2333 + (rs_number-1)*4, 2).addClass('data_td'))
				tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("rs_response_timeout"), 0x2333 + (rs_number-1)*4, 2).addClass('data_td'))
				tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("rs_interbyte_timeout"), 0x2333 + (rs_number-1)*4, 3).addClass('data_td'))
				//tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("rs_retry_count"), 0x2333 + (rs_number-1)*4, 5))

				tab_body[tab_number].append($('<tr>').addClass('table_header_2').append($('<td colspan="2">').text(l100n.localize_string("rs_rtu_client_settings"))))
				tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("rs_enable"), 0x2393, rs_number).addClass('data_td'))
				//let client_requests_button = $(`<input type="submit" id="client_requests_button">`)
				let client_requests_button = $(`<a href='raw_access.html' target='_blank' id="client_requests_button">`)
				client_requests_button.attr({"index": 5100 + 300*(rs_number-1)})
				client_requests_button.text(`${l100n.localize_string("Modbus Serial")} ${rs_number} ${l100n.localize_string("Client Requests")}`)
				tab_body[tab_number].append($('<tr>').append($('<td>').append(client_requests_button)))
			}
			if (tab_type == interface_types.rs)
			{
				tab_body[tab_number].append($('<tr>').addClass('table_header_2').append($('<td colspan="2">').text(l100n.localize_string("Modbus TCP GW Serial Settings"))))
				tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("rs_gw_enable"), 0x2383 + (rs_number-1)*4, 1).addClass('data_td'))
				tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("rs_gw_start_addr"), 0x2383 + (rs_number-1)*4, 2).addClass('data_td'))
				tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("rs_gw_end_addr"), 0x2383 + (rs_number-1)*4, 3).addClass('data_td'))
				tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("rs_gw_Address_Offset"), 0x2383 + (rs_number-1)*4, 4).addClass('data_td'))
				//tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("rs_gw_Broadcast"), 0x2383 + rs_number*4, 5).addClass('data_td'))
				//tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("rs_gw_ip_addr_number"), 0x2383 + rs_number*4, 6).addClass('data_td'))
				//tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("rs_gw_ip_port"), 0x2383 + rs_number*4, 7).addClass('data_td'))
			}

			rs_number++
		}
		else if (tab_type == interface_types.can)
		{
			if (can_is_one) { ul.append($(`<li><a href="#nw_tab${tab_number}">${tab_name[tab_type]}</a></li>`)) }
			else { ul.append($(`<li><a href="#nw_tab${tab_number}">${tab_name[tab_type]} ${can_number}</a></li>`)) }
			tab_body[tab_number] = $(`<tbody id="nw_tab${tab_number}">`).addClass('nowrap_td').addClass('data_td')
			tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("can_enable"), 0x2103 + (can_number-1)*4, 1))
			tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("can_data_rate"), 0x2103 + (can_number-1)*4, 2))
			tab_body[tab_number].append($('<tr>').addClass('table_header').append($('<td colspan="2">').text(l100n.localize_string("can_status"))))
			tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("can_rx_count"), 0x2101 + (can_number-1)*4, 1))
			tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("can_tx_count"), 0x2101 + (can_number-1)*4, 2))
			tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("can_rx_error_count"), 0x2101 + (can_number-1)*4, 3))
			tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("can_tx_error_count"), 0x2101 + (can_number-1)*4, 4))
			tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("can_error_code"), 0x2101 + (can_number-1)*4, 5))
			tab_body[tab_number].append($('<tr>').addClass('table_header').append($('<td colspan="2">').text(l100n.localize_string("can_settings"))))
			for (i = 1; i <= configuration.can_nodes_count; ++i)
			{
				tab_body[tab_number].append(common.form_tag_tr(`${l100n.localize_string("node_id")} ${i}`, 0x2303 + (can_number-1)*4, i))
			}
			can_number++
		}
		else if (tab_type == interface_types.tcp_slave)
		{
		}
		else if (tab_type == interface_types.iec104)
		{
			ul.append($(`<li><a href="#nw_tab${tab_number}">${tab_name[tab_type]}</a></li>`))
			tab_body[tab_number] = $(`<tbody id="nw_tab${tab_number}">`).addClass('nowrap_td').addClass('data_td')
			tab_body[tab_number].append($('<tr>').addClass('table_header').append($('<td colspan="2">').text(l100n.localize_string("iec104_status"))))
			tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("iec104_Enabled"), 0x2601, 1))
			tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("iec104_Client_Count"), 0x2601, 2))
			tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("iec104_Misconfig"), 0x2601, 3))
			tab_body[tab_number].append($('<tr>').addClass('table_header').append($('<td colspan="2">').text(l100n.localize_string("iec104_settings"))))
			tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("iec104_Enable"), 0x2603, 1))
			tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("iec104_Port"), 0x2603, 2))
			tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("iec104_k"), 0x2603, 3))
			tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("iec104_w"), 0x2603, 4))
			tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("iec104_t0"), 0x2603, 5))
			tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("iec104_t1"), 0x2603, 6))
			tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("iec104_t2"), 0x2603, 7))
			tab_body[tab_number].append(common.form_tag_tr(l100n.localize_string("iec104_t3"), 0x2603, 8))
			tab_body[tab_number].append(`<br><a href="iec104_settings_view.html" target="_blank">${l100n.localize_string("iec104_mapping_page")}</a>`)
		}
		else if (tab_type == interface_types.dlms)
		{
			ul.append($(`<li><a href="#dlms_tab">DLMS</a></li>`))
			tab_body[tab_number] = $(`<tbody id="dlms_tab">`).addClass('nowrap_td').addClass('data_td')
			tab_body[tab_number].append(common.form_tag_tr_param({name: l100n.localize_string("Enable"), index: 0x2503, sub: 1}))
			tab_body[tab_number].append(common.form_tag_tr_param({name: l100n.localize_string("dlms_Device Address"), index: 0x2503, sub: 2}))
			table.append(tab_body[tab_number])
		}

		table.append(tab_body[tab_number])
	}

	$(document).on('click', '#client_requests_button', function()
	{
		let index_number = $(this).attr("index");
		console.log(index_number)
		localStorage.setItem("selected_page_index", index_number)
		//localStorage.setItem("selected_accordion_header", $(this).index())
		//window.open('raw_access.html', '_blank');
	})
	
	//await get_set_value.set_eds_object()
	const eds_script = utils.load_script('eds.js')
	await Promise.all([
			eds_script
		])
	.then(() => eds.get_eds_object())	
	.then(eds_object => {
		//console.log(eds_object) 
		if ("221B" in eds_object)
		{
			ul.append($(`<li><a href="#rndis_tab">RNDIS (USB)</a></li>`))
			let rndis_tab_body = $(`<tbody id="rndis_tab">`).addClass('nowrap_td').addClass('data_td')
			rndis_tab_body.append(common.form_tag_tr_param(
				{name: l100n.localize_string("rndis_ip"), index: 0x221B, sub: 2}))
			table.append(rndis_tab_body)
		}
	})

	let tabs_div = $('<div class="tab-class">').append(ul).append(table)

	let board_head = $('<div>').append(l100n.localize_string("Network Settings")).addClass("accordion-header")
	let board_body = $('<div>').addClass("accordion-body").append(tabs_div)
	board_body.append(`<br><a href="modbus_mappings_reader.html" target="_blank" id="Modbus_mappings">${l100n.localize_string("modbus_mapping_page")}</a>`)
	$("#network_settings").append(board_head).append(board_body)

	utils.load_script('external/jquery.ipmask.js')
	.then(() => { $('.ip_addr').ipmask() })
}

})(this.network_settings = {})
